/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.ScriptFormattingStrategy;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;

public class CommonMultiPassContentFormatter
extends MultiPassContentFormatter {
    private IDocumentScopeManager documentScopeManager;
    private final String fType;
    private final String fPartitioning;
    private String masterContentType;
    private Set<String> slaveContentTypes;

    public CommonMultiPassContentFormatter(String partitioning, String type) {
        super(partitioning, type);
        this.fPartitioning = partitioning;
        this.fType = type;
        this.documentScopeManager = CommonEditorPlugin.getDefault().getDocumentScopeManager();
        this.slaveContentTypes = new HashSet<String>();
        this.masterContentType = "";
    }

    public void setMasterStrategy(String contentType) {
        this.masterContentType = contentType;
        super.setMasterStrategy((IFormattingStrategy)new ScriptFormattingStrategy(contentType));
    }

    public void setSlaveStrategy(String contentType) {
        this.slaveContentTypes.add(contentType);
        super.setSlaveStrategy((IFormattingStrategy)new ScriptFormattingStrategy(contentType), contentType);
    }

    protected void formatSlaves(IFormattingContext context, IDocument document, int offset, int length) {
        context.setProperty((Object)"formatting.context.isSlave", (Object)Boolean.TRUE);
        IRegion selectionRegion = (IRegion)context.getProperty((Object)"formatting.context.region");
        try {
            ITypedRegion[] partitions;
            int updatedMinLength = document.getLength();
            if (selectionRegion != null) {
                updatedMinLength = Math.min(updatedMinLength, selectionRegion.getLength());
            }
            if (!this.fType.equals((partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.fPartitioning, (int)offset, (int)Math.min(length, updatedMinLength), (boolean)false))[0].getType())) {
                partitions[0] = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)partitions[0].getOffset(), (boolean)false);
            }
            if (partitions.length > 1 && !this.fType.equals(partitions[partitions.length - 1].getType())) {
                partitions[partitions.length - 1] = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)partitions[partitions.length - 1].getOffset(), (boolean)false);
            }
            String type = null;
            ITypedRegion partition = null;
            int start = -1;
            int contentLength = 0;
            String lastContentType = null;
            int index = partitions.length - 1;
            while (index >= 0) {
                partition = partitions[index];
                type = partition.getType();
                boolean isDefaultType = this.fType.equals(type);
                QualifiedContentType qualifiedContentType = this.documentScopeManager.getContentType(document, partition.getOffset());
                String contentType = null;
                String extractedContentType = this.extractContentType(qualifiedContentType);
                if (this.slaveContentTypes.contains(extractedContentType)) {
                    contentType = extractedContentType;
                }
                if (!(isDefaultType || contentType == null || contentType.equals(this.masterContentType) || lastContentType != null && !lastContentType.equals(contentType))) {
                    start = partition.getOffset();
                    contentLength += partition.getLength();
                    lastContentType = contentType;
                } else if (lastContentType != null) {
                    if (ScriptFormatterManager.hasFormatterFor(lastContentType)) {
                        this.updateContex(context, lastContentType, start, contentLength);
                        this.formatSlave(context, document, start, contentLength, lastContentType);
                    }
                    start = -1;
                    contentLength = 0;
                    lastContentType = null;
                }
                --index;
            }
            if (lastContentType != null && ScriptFormatterManager.hasFormatterFor(lastContentType)) {
                this.updateContex(context, lastContentType, start, contentLength);
                this.formatSlave(context, document, start, contentLength, lastContentType);
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private void updateContex(IFormattingContext context, String contentType, int offset, int length) {
        IScriptFormatterFactory factory = ScriptFormatterManager.getSelected((String)contentType);
        if (factory != null) {
            factory.setMainContentType(contentType);
            if (context != null) {
                context.setProperty((Object)"formatting.context.formatterId", (Object)factory.getId());
                context.setProperty((Object)"formatting.context.partition", (Object)new TypedPosition(offset, length, contentType));
                context.setProperty((Object)"formatting.context.canConsumeIndent", (Object)factory.canConsumePreviousIndent());
            }
        }
    }

    protected String extractContentType(QualifiedContentType qualifiedContentType) {
        if (qualifiedContentType == null) {
            return null;
        }
        int partCount = qualifiedContentType.getPartCount();
        if (partCount > 2) {
            return qualifiedContentType.getParts()[partCount - 2];
        }
        return null;
    }
}

